/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.ITickList;
import net.minecraft.world.LightType;
import net.minecraft.world.SerializableTickList;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkPrimerTickList;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkSerializer {
    private static final Logger field_222658_a = LogManager.getLogger();

    public static ChunkPrimer func_222656_a(ServerWorld p_222656_0_, TemplateManager p_222656_1_, PointOfInterestManager p_222656_2_, ChunkPos p_222656_3_, CompoundNBT p_222656_4_) {
        IChunk ichunk;
        ChunkGenerator chunkgenerator = p_222656_0_.func_72863_F().func_201711_g();
        BiomeProvider biomeprovider = chunkgenerator.func_202090_b();
        CompoundNBT compoundnbt = p_222656_4_.func_74775_l("Level");
        ChunkPos chunkpos = new ChunkPos(compoundnbt.func_74762_e("xPos"), compoundnbt.func_74762_e("zPos"));
        if (!Objects.equals(p_222656_3_, chunkpos)) {
            field_222658_a.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", (Object)p_222656_3_, (Object)p_222656_3_, (Object)chunkpos);
        }
        BiomeContainer biomecontainer = new BiomeContainer(p_222656_0_.func_241828_r().func_243612_b(Registry.field_239720_u_), p_222656_3_, biomeprovider, compoundnbt.func_150297_b("Biomes", 11) ? compoundnbt.func_74759_k("Biomes") : null);
        UpgradeData upgradedata = compoundnbt.func_150297_b("UpgradeData", 10) ? new UpgradeData(compoundnbt.func_74775_l("UpgradeData")) : UpgradeData.field_196994_a;
        ChunkPrimerTickList chunkprimerticklist = new ChunkPrimerTickList(p_222652_0_ -> p_222652_0_ == null || p_222652_0_.func_176223_P().func_196958_f(), p_222656_3_, compoundnbt.func_150295_c("ToBeTicked", 9));
        ChunkPrimerTickList chunkprimerticklist1 = new ChunkPrimerTickList(p_222646_0_ -> p_222646_0_ == null || p_222646_0_ == Fluids.field_204541_a, p_222656_3_, compoundnbt.func_150295_c("LiquidsToBeTicked", 9));
        boolean flag = compoundnbt.func_74767_n("isLightOn");
        ListNBT listnbt = compoundnbt.func_150295_c("Sections", 10);
        int i = 16;
        ChunkSection[] achunksection = new ChunkSection[16];
        boolean flag1 = p_222656_0_.func_230315_m_().func_218272_d();
        ServerChunkProvider abstractchunkprovider = p_222656_0_.func_72863_F();
        WorldLightManager worldlightmanager = abstractchunkprovider.func_212863_j_();
        if (flag) {
            worldlightmanager.func_223115_b(p_222656_3_, true);
        }
        for (int j = 0; j < listnbt.size(); ++j) {
            CompoundNBT compoundnbt1 = listnbt.func_150305_b(j);
            byte k = compoundnbt1.func_74771_c("Y");
            if (compoundnbt1.func_150297_b("Palette", 9) && compoundnbt1.func_150297_b("BlockStates", 12)) {
                ChunkSection chunksection = new ChunkSection(k << 4);
                chunksection.func_186049_g().func_222642_a(compoundnbt1.func_150295_c("Palette", 10), compoundnbt1.func_197645_o("BlockStates"));
                chunksection.func_76672_e();
                if (!chunksection.func_76663_a()) {
                    achunksection[k] = chunksection;
                }
                p_222656_2_.func_219139_a(p_222656_3_, chunksection);
            }
            if (!flag) continue;
            if (compoundnbt1.func_150297_b("BlockLight", 7)) {
                worldlightmanager.func_215574_a(LightType.BLOCK, SectionPos.func_218156_a((ChunkPos)p_222656_3_, (int)k), new NibbleArray(compoundnbt1.func_74770_j("BlockLight")), true);
            }
            if (!flag1 || !compoundnbt1.func_150297_b("SkyLight", 7)) continue;
            worldlightmanager.func_215574_a(LightType.SKY, SectionPos.func_218156_a((ChunkPos)p_222656_3_, (int)k), new NibbleArray(compoundnbt1.func_74770_j("SkyLight")), true);
        }
        long k1 = compoundnbt.func_74763_f("InhabitedTime");
        ChunkStatus.Type chunkstatus$type = ChunkSerializer.func_222651_a(p_222656_4_);
        if (chunkstatus$type == ChunkStatus.Type.LEVELCHUNK) {
            Object iticklist = compoundnbt.func_150297_b("TileTicks", 9) ? SerializableTickList.func_222984_a((ListNBT)compoundnbt.func_150295_c("TileTicks", 10), arg_0 -> Registry.field_212618_g.func_177774_c(arg_0), arg_0 -> Registry.field_212618_g.func_82594_a(arg_0)) : chunkprimerticklist;
            Object iticklist1 = compoundnbt.func_150297_b("LiquidTicks", 9) ? SerializableTickList.func_222984_a((ListNBT)compoundnbt.func_150295_c("LiquidTicks", 10), arg_0 -> Registry.field_212619_h.func_177774_c(arg_0), arg_0 -> Registry.field_212619_h.func_82594_a(arg_0)) : chunkprimerticklist1;
            ichunk = new Chunk(p_222656_0_.func_201672_e(), p_222656_3_, biomecontainer, upgradedata, (ITickList<Block>)iticklist, (ITickList<Fluid>)iticklist1, k1, achunksection, p_222648_1_ -> ChunkSerializer.func_222650_a(compoundnbt, p_222648_1_));
            if (compoundnbt.func_74764_b("ForgeCaps")) {
                ((Chunk)ichunk).readCapsFromNBT(compoundnbt.func_74775_l("ForgeCaps"));
            }
        } else {
            ChunkPrimer chunkprimer = new ChunkPrimer(p_222656_3_, upgradedata, achunksection, (ChunkPrimerTickList<Block>)chunkprimerticklist, (ChunkPrimerTickList<Fluid>)chunkprimerticklist1);
            chunkprimer.func_225548_a_(biomecontainer);
            ichunk = chunkprimer;
            chunkprimer.func_177415_c(k1);
            chunkprimer.func_201574_a(ChunkStatus.func_222591_a(compoundnbt.func_74779_i("Status")));
            if (chunkprimer.func_201589_g().func_209003_a(ChunkStatus.field_222613_i)) {
                chunkprimer.func_217306_a(worldlightmanager);
            }
            if (!flag && chunkprimer.func_201589_g().func_209003_a(ChunkStatus.field_222614_j)) {
                for (BlockPos blockpos : BlockPos.func_191531_b((int)p_222656_3_.func_180334_c(), (int)0, (int)p_222656_3_.func_180333_d(), (int)p_222656_3_.func_180332_e(), (int)255, (int)p_222656_3_.func_180330_f())) {
                    if (ichunk.func_180495_p(blockpos).getLightValue(ichunk, blockpos) == 0) continue;
                    chunkprimer.func_201637_h(blockpos);
                }
            }
        }
        ichunk.func_217305_b(flag);
        CompoundNBT compoundnbt3 = compoundnbt.func_74775_l("Heightmaps");
        EnumSet<Heightmap.Type> enumset = EnumSet.noneOf(Heightmap.Type.class);
        for (Heightmap.Type heightmap$type : ichunk.func_201589_g().func_222595_h()) {
            String s = heightmap$type.func_203500_b();
            if (compoundnbt3.func_150297_b(s, 12)) {
                ichunk.func_201607_a(heightmap$type, compoundnbt3.func_197645_o(s));
                continue;
            }
            enumset.add(heightmap$type);
        }
        Heightmap.func_222690_a((IChunk)ichunk, enumset);
        CompoundNBT compoundnbt4 = compoundnbt.func_74775_l("Structures");
        ichunk.func_201612_a(ChunkSerializer.func_235967_a_(p_222656_1_, compoundnbt4, p_222656_0_.func_72905_C()));
        ForgeHooks.fixNullStructureReferences((IChunk)ichunk, ChunkSerializer.func_227075_a_(p_222656_3_, compoundnbt4));
        if (compoundnbt.func_74767_n("shouldSave")) {
            ichunk.func_177427_f(true);
        }
        ListNBT listnbt3 = compoundnbt.func_150295_c("PostProcessing", 9);
        for (int l1 = 0; l1 < listnbt3.size(); ++l1) {
            ListNBT listnbt1 = listnbt3.func_202169_e(l1);
            for (int l = 0; l < listnbt1.size(); ++l) {
                ichunk.func_201636_b(listnbt1.func_202170_f(l), l1);
            }
        }
        if (chunkstatus$type == ChunkStatus.Type.LEVELCHUNK) {
            MinecraftForge.EVENT_BUS.post((Event)new ChunkDataEvent.Load(ichunk, p_222656_4_, chunkstatus$type));
            return new ChunkPrimerWrapper((Chunk)ichunk);
        }
        ChunkPrimer chunkprimer1 = (ChunkPrimer)ichunk;
        ListNBT listnbt4 = compoundnbt.func_150295_c("Entities", 10);
        for (int i2 = 0; i2 < listnbt4.size(); ++i2) {
            chunkprimer1.func_201626_b(listnbt4.func_150305_b(i2));
        }
        ListNBT listnbt5 = compoundnbt.func_150295_c("TileEntities", 10);
        for (int i1 = 0; i1 < listnbt5.size(); ++i1) {
            CompoundNBT compoundnbt2 = listnbt5.func_150305_b(i1);
            ichunk.func_201591_a(compoundnbt2);
        }
        ListNBT listnbt6 = compoundnbt.func_150295_c("Lights", 9);
        for (int j2 = 0; j2 < listnbt6.size(); ++j2) {
            ListNBT listnbt2 = listnbt6.func_202169_e(j2);
            for (int j1 = 0; j1 < listnbt2.size(); ++j1) {
                chunkprimer1.func_201646_a(listnbt2.func_202170_f(j1), j2);
            }
        }
        CompoundNBT compoundnbt5 = compoundnbt.func_74775_l("CarvingMasks");
        for (String s1 : compoundnbt5.func_150296_c()) {
            GenerationStage.Carving generationstage$carving = GenerationStage.Carving.valueOf((String)s1);
            chunkprimer1.func_205767_a(generationstage$carving, BitSet.valueOf(compoundnbt5.func_74770_j(s1)));
        }
        MinecraftForge.EVENT_BUS.post((Event)new ChunkDataEvent.Load(ichunk, p_222656_4_, chunkstatus$type));
        return chunkprimer1;
    }

    public static CompoundNBT func_222645_a(ServerWorld p_222645_0_, IChunk p_222645_1_) {
        BiomeContainer biomecontainer;
        ChunkPos chunkpos = p_222645_1_.func_76632_l();
        CompoundNBT compoundnbt = new CompoundNBT();
        CompoundNBT compoundnbt1 = new CompoundNBT();
        compoundnbt.func_74768_a("DataVersion", SharedConstants.func_215069_a().getWorldVersion());
        compoundnbt.func_218657_a("Level", compoundnbt1);
        compoundnbt1.func_74768_a("xPos", chunkpos.field_77276_a);
        compoundnbt1.func_74768_a("zPos", chunkpos.field_77275_b);
        compoundnbt1.func_74772_a("LastUpdate", p_222645_0_.func_82737_E());
        compoundnbt1.func_74772_a("InhabitedTime", p_222645_1_.func_177416_w());
        compoundnbt1.func_74778_a("Status", p_222645_1_.func_201589_g().func_222596_d());
        UpgradeData upgradedata = p_222645_1_.func_196966_y();
        if (!upgradedata.func_196988_a()) {
            compoundnbt1.func_218657_a("UpgradeData", upgradedata.func_196992_b());
        }
        ChunkSection[] achunksection = p_222645_1_.func_76587_i();
        ListNBT listnbt = new ListNBT();
        ServerWorldLightManager worldlightmanager = p_222645_0_.func_72863_F().func_212863_j_();
        boolean flag = p_222645_1_.func_217310_r();
        for (int i = -1; i < 17; ++i) {
            int j = i;
            ChunkSection chunksection = Arrays.stream(achunksection).filter(p_222657_1_ -> p_222657_1_ != null && p_222657_1_.func_222632_g() >> 4 == j).findFirst().orElse(Chunk.field_186036_a);
            NibbleArray nibblearray = worldlightmanager.func_215569_a(LightType.BLOCK).func_215612_a(SectionPos.func_218156_a((ChunkPos)chunkpos, (int)j));
            NibbleArray nibblearray1 = worldlightmanager.func_215569_a(LightType.SKY).func_215612_a(SectionPos.func_218156_a((ChunkPos)chunkpos, (int)j));
            if (chunksection == Chunk.field_186036_a && nibblearray == null && nibblearray1 == null) continue;
            GenerationStage.Carving[] compoundnbt2 = new CompoundNBT();
            compoundnbt2.func_74774_a("Y", (byte)(j & 0xFF));
            if (chunksection != Chunk.field_186036_a) {
                chunksection.func_186049_g().func_196963_b((CompoundNBT)compoundnbt2, "Palette", "BlockStates");
            }
            if (nibblearray != null && !nibblearray.func_215655_c()) {
                compoundnbt2.func_74773_a("BlockLight", nibblearray.func_177481_a());
            }
            if (nibblearray1 != null && !nibblearray1.func_215655_c()) {
                compoundnbt2.func_74773_a("SkyLight", nibblearray1.func_177481_a());
            }
            listnbt.add((Object)compoundnbt2);
        }
        compoundnbt1.func_218657_a("Sections", (INBT)listnbt);
        if (flag) {
            compoundnbt1.func_74757_a("isLightOn", true);
        }
        if ((biomecontainer = p_222645_1_.func_225549_i_()) != null) {
            compoundnbt1.func_74783_a("Biomes", biomecontainer.func_227055_a_());
        }
        ListNBT listnbt1 = new ListNBT();
        for (BlockPos blockpos : p_222645_1_.func_203066_o()) {
            CompoundNBT compoundnbt4 = p_222645_1_.func_223134_j(blockpos);
            if (compoundnbt4 == null) continue;
            listnbt1.add((Object)compoundnbt4);
        }
        compoundnbt1.func_218657_a("TileEntities", (INBT)listnbt1);
        ListNBT listnbt2 = new ListNBT();
        if (p_222645_1_.func_201589_g().func_202129_d() == ChunkStatus.Type.LEVELCHUNK) {
            Chunk chunk = (Chunk)p_222645_1_;
            chunk.func_177409_g(false);
            for (int k = 0; k < chunk.func_177429_s().length; ++k) {
                for (Entity entity : chunk.func_177429_s()[k]) {
                    CompoundNBT compoundnbt3 = new CompoundNBT();
                    try {
                        if (!entity.func_70039_c(compoundnbt3)) continue;
                        chunk.func_177409_g(true);
                        listnbt2.add((Object)compoundnbt3);
                    }
                    catch (Exception e) {
                        LogManager.getLogger().error("An Entity type {} has thrown an exception trying to write state. It will not persist. Report this to the mod author", entity.func_200600_R(), (Object)e);
                    }
                }
            }
            try {
                CompoundNBT capTag = chunk.writeCapsToNBT();
                if (capTag != null) {
                    compoundnbt1.func_218657_a("ForgeCaps", capTag);
                }
            }
            catch (Exception exception) {
                LogManager.getLogger().error("A capability provider has thrown an exception trying to write state. It will not persist. Report this to the mod author", (Throwable)exception);
            }
        } else {
            ChunkPrimer chunkprimer = (ChunkPrimer)p_222645_1_;
            listnbt2.addAll(chunkprimer.func_201652_l());
            compoundnbt1.func_218657_a("Lights", (INBT)ChunkSerializer.func_222647_a(chunkprimer.func_201647_i()));
            CompoundNBT compoundnbt5 = new CompoundNBT();
            for (GenerationStage.Carving generationstage$carving : GenerationStage.Carving.values()) {
                BitSet bitset = chunkprimer.func_205749_a(generationstage$carving);
                if (bitset == null) continue;
                compoundnbt5.func_74773_a(generationstage$carving.toString(), bitset.toByteArray());
            }
            compoundnbt1.func_218657_a("CarvingMasks", compoundnbt5);
        }
        compoundnbt1.func_218657_a("Entities", (INBT)listnbt2);
        ITickList<Block> iticklist = p_222645_1_.func_205218_i_();
        if (iticklist instanceof ChunkPrimerTickList) {
            compoundnbt1.func_218657_a("ToBeTicked", (INBT)((ChunkPrimerTickList)iticklist).func_205379_a());
        } else if (iticklist instanceof SerializableTickList) {
            compoundnbt1.func_218657_a("TileTicks", (INBT)((SerializableTickList)iticklist).func_234857_b_());
        } else {
            compoundnbt1.func_218657_a("TileTicks", (INBT)p_222645_0_.func_205220_G_().func_219503_a(chunkpos));
        }
        ITickList<Fluid> iticklist1 = p_222645_1_.func_212247_j();
        if (iticklist1 instanceof ChunkPrimerTickList) {
            compoundnbt1.func_218657_a("LiquidsToBeTicked", (INBT)((ChunkPrimerTickList)iticklist1).func_205379_a());
        } else if (iticklist1 instanceof SerializableTickList) {
            compoundnbt1.func_218657_a("LiquidTicks", (INBT)((SerializableTickList)iticklist1).func_234857_b_());
        } else {
            compoundnbt1.func_218657_a("LiquidTicks", (INBT)p_222645_0_.func_205219_F_().func_219503_a(chunkpos));
        }
        compoundnbt1.func_218657_a("PostProcessing", (INBT)ChunkSerializer.func_222647_a(p_222645_1_.func_201614_D()));
        CompoundNBT compoundnbt6 = new CompoundNBT();
        for (Map.Entry<Heightmap.Type, Heightmap> entry : p_222645_1_.func_217311_f()) {
            if (!p_222645_1_.func_201589_g().func_222595_h().contains(entry.getKey())) continue;
            compoundnbt6.func_218657_a(entry.getKey().func_203500_b(), (INBT)new LongArrayNBT(entry.getValue().func_202269_a()));
        }
        compoundnbt1.func_218657_a("Heightmaps", compoundnbt6);
        compoundnbt1.func_218657_a("Structures", ChunkSerializer.func_222649_a(chunkpos, p_222645_1_.func_201609_c(), p_222645_1_.func_201604_d()));
        return compoundnbt;
    }

    public static ChunkStatus.Type func_222651_a(@Nullable CompoundNBT p_222651_0_) {
        ChunkStatus chunkstatus;
        if (p_222651_0_ != null && (chunkstatus = ChunkStatus.func_222591_a(p_222651_0_.func_74775_l("Level").func_74779_i("Status"))) != null) {
            return chunkstatus.func_202129_d();
        }
        return ChunkStatus.Type.PROTOCHUNK;
    }

    private static void func_222650_a(CompoundNBT p_222650_0_, Chunk p_222650_1_) {
        ListNBT listnbt = p_222650_0_.func_150295_c("Entities", 10);
        World world = p_222650_1_.func_177412_p();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            EntityType.func_220335_a(compoundnbt, world, p_222655_1_ -> {
                p_222650_1_.func_76612_a((Entity)((Object)p_222655_1_));
                return p_222655_1_;
            });
            p_222650_1_.func_177409_g(true);
        }
        ListNBT listnbt1 = p_222650_0_.func_150295_c("TileEntities", 10);
        for (int j = 0; j < listnbt1.size(); ++j) {
            CompoundNBT compoundnbt1 = listnbt1.func_150305_b(j);
            boolean flag = compoundnbt1.func_74767_n("keepPacked");
            if (flag) {
                p_222650_1_.func_201591_a(compoundnbt1);
                continue;
            }
            BlockPos blockpos = new BlockPos(compoundnbt1.func_74762_e("x"), compoundnbt1.func_74762_e("y"), compoundnbt1.func_74762_e("z"));
            TileEntity tileentity = TileEntity.func_235657_b_(p_222650_1_.func_180495_p(blockpos), compoundnbt1);
            if (tileentity == null) continue;
            p_222650_1_.func_150813_a(tileentity);
        }
    }

    private static CompoundNBT func_222649_a(ChunkPos p_222649_0_, Map<Structure<?>, StructureStart<?>> p_222649_1_, Map<Structure<?>, LongSet> p_222649_2_) {
        CompoundNBT compoundnbt = new CompoundNBT();
        CompoundNBT compoundnbt1 = new CompoundNBT();
        for (Map.Entry<Structure<?>, StructureStart<?>> entry : p_222649_1_.entrySet()) {
            compoundnbt1.func_218657_a(entry.getKey().func_143025_a(), entry.getValue().func_143021_a(p_222649_0_.field_77276_a, p_222649_0_.field_77275_b));
        }
        compoundnbt.func_218657_a("Starts", compoundnbt1);
        CompoundNBT compoundnbt2 = new CompoundNBT();
        for (Map.Entry<Structure<?>, LongSet> entry1 : p_222649_2_.entrySet()) {
            compoundnbt2.func_218657_a(entry1.getKey().func_143025_a(), (INBT)new LongArrayNBT(entry1.getValue()));
        }
        compoundnbt.func_218657_a("References", compoundnbt2);
        return compoundnbt;
    }

    private static Map<Structure<?>, StructureStart<?>> func_235967_a_(TemplateManager p_235967_0_, CompoundNBT p_235967_1_, long p_235967_2_) {
        HashMap map = Maps.newHashMap();
        CompoundNBT compoundnbt = p_235967_1_.func_74775_l("Starts");
        for (String s : compoundnbt.func_150296_c()) {
            String s1 = s.toLowerCase(Locale.ROOT);
            Structure structure = (Structure)((Object)Structure.field_236365_a_.get((Object)s1));
            if (structure == null) {
                field_222658_a.error("Unknown structure start: {}", (Object)s1);
                continue;
            }
            StructureStart<?> structurestart = Structure.func_236393_a_(p_235967_0_, compoundnbt.func_74775_l(s), p_235967_2_);
            if (structurestart == null) continue;
            map.put(structure, structurestart);
        }
        return map;
    }

    private static Map<Structure<?>, LongSet> func_227075_a_(ChunkPos p_227075_0_, CompoundNBT p_227075_1_) {
        HashMap map = Maps.newHashMap();
        CompoundNBT compoundnbt = p_227075_1_.func_74775_l("References");
        for (String s : compoundnbt.func_150296_c()) {
            map.put(Structure.field_236365_a_.get((Object)s.toLowerCase(Locale.ROOT)), new LongOpenHashSet(Arrays.stream(compoundnbt.func_197645_o(s)).filter(p_227074_2_ -> {
                ChunkPos chunkpos = new ChunkPos(p_227074_2_);
                if (chunkpos.func_226661_a_(p_227075_0_) > 8) {
                    field_222658_a.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", (Object)s, (Object)chunkpos, (Object)p_227075_0_);
                    return false;
                }
                return true;
            }).toArray()));
        }
        return map;
    }

    public static ListNBT func_222647_a(ShortList[] p_222647_0_) {
        ListNBT listnbt = new ListNBT();
        for (ShortList shortlist : p_222647_0_) {
            ListNBT listnbt1 = new ListNBT();
            if (shortlist != null) {
                for (Short oshort : shortlist) {
                    listnbt1.add((Object)ShortNBT.func_229701_a_((short)oshort));
                }
            }
            listnbt.add((Object)listnbt1);
        }
        return listnbt;
    }
}

